# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class CookieYandexuidBaseError(BaseCoreError):
    pass


class CookieYandexuidUnpackError(CookieYandexuidBaseError):
    pass


YANDEXUID_TIMESTAMP_LENGTH = 10


def parse_yandexuid_timestamp(cookie):
    if not cookie:
        raise CookieYandexuidUnpackError()
    timestamp = str(cookie)[-YANDEXUID_TIMESTAMP_LENGTH:]
    if not timestamp.isdigit():
        raise CookieYandexuidUnpackError()
    return int(timestamp)
