# -*- coding: utf-8 -*-
import logging

from passport.backend.core.builders.kolmogor import BaseKolmogorError
from passport.backend.core.conf import settings


log = logging.getLogger(__name__)


def antifraud_counters():
    return {
        settings.KOLMOGOR_KEYSPACE_ANTIFRAUD_FAIL_CALLS_COUNTER_10MIN: settings.KOLMOGOR_ANTIFRAUD_CALL_FAIL_COUNTERS_10MIN,
        settings.KOLMOGOR_KEYSPACE_ANTIFRAUD_FAIL_CALLS_COUNTER_1H: settings.KOLMOGOR_ANTIFRAUD_CALL_FAIL_COUNTERS_1H,
        settings.KOLMOGOR_KEYSPACE_ANTIFRAUD_FAIL_CALLS_COUNTER_24H: settings.KOLMOGOR_ANTIFRAUD_CALL_FAIL_COUNTERS_24H,
    }


def incr_af_calls_counter(kolmogor):
    counters = antifraud_counters()
    try:
        for space in counters:
            kolmogor.inc(
                space=space,
                keys=[counters[space]],
            )
    except BaseKolmogorError:
        log.warning('Request to Kolmogor failed while incrementing calls count')


def is_af_limit_exceeded(kolmogor):
    counters = antifraud_counters()
    try:
        for space in counters:
            key = counters[space]
            counter = kolmogor.get(
                space=space,
                keys=[key],
            )

            if counter[key] > settings.COUNTERS[key]:
                return True

    except BaseKolmogorError:
        return True

    return False
