# -*- coding: utf-8 -*-
from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets


def get_counter():
    prefix = settings.AUTH_EMAIL_RECENTLY_SENT_COUNTER
    return get_buckets(prefix)


def incr_counter_and_check_limit(uid):
    counter = get_counter()
    limit = counter.limit + 1  # так как сначала инкрементим, а потом проверяем на превышение лимита
    return counter.incr(uid) >= limit or counter.hit_limit(uid, limit)
