# -*- coding: utf-8 -*-
from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets


def get_counter():
    prefix = settings.BAD_RFC_OTP_COUNTER
    return get_buckets(prefix)


def incr_counter_and_check_limit_afterwards(uid):
    counter = get_counter()
    limit = counter.limit
    return counter.incr(uid) >= limit or counter.hit_limit(uid, limit)
