# -*- coding: utf-8 -*-
from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets
from passport.backend.core.counters.utils import is_trusted_country


def get_counter(user_ip):
    if is_trusted_country(user_ip):
        prefix = settings.PHONE_CONFIRMATION_CALLS_PER_IP_LIMIT_COUNTER
    else:
        prefix = settings.UNTRUSTED_PHONE_CONFIRMATION_CALLS_PER_IP_LIMIT_COUNTER
    return get_buckets(prefix)
