# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets


def get_per_ip_buckets():
    return get_buckets(settings.CHECK_ANSWER_PER_IP_LIMIT_COUNTER)


def get_per_uid_buckets():
    return get_buckets(settings.CHECK_ANSWER_PER_UID_LIMIT_COUNTER)


def is_limit_exceeded(user_ip, uid, increment=True, ip_limit=None, uid_limit=None):
    exceeded = False

    per_ip_buckets = get_per_ip_buckets()
    if per_ip_buckets.hit_limit_by_ip(user_ip, limit=ip_limit):
        exceeded = True

    per_uid_buckets = get_per_uid_buckets()
    if per_uid_buckets.hit_limit(uid, limit=uid_limit):
        exceeded = True

    if increment:
        increment_counters(user_ip, uid)

    return exceeded


def increment_counters(user_ip, uid):
    get_per_ip_buckets().incr(user_ip)
    get_per_uid_buckets().incr(uid)
