# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets
from passport.backend.core.counters.check_answer_counter import get_per_ip_buckets


def get_per_ip_and_uid_buckets():
    return get_buckets(settings.CHECK_ANSWER_PER_IP_AND_UID_LIMIT_COUNTER)


def is_limit_exceeded(user_ip, uid):
    exceeded = False

    per_ip_buckets = get_per_ip_buckets()
    if per_ip_buckets.hit_limit_by_ip(user_ip):
        exceeded = True
    per_ip_buckets.incr(user_ip)

    per_ip_and_uid_buckets = get_per_ip_and_uid_buckets()
    key = '%s:%s' % (user_ip, uid)
    if per_ip_and_uid_buckets.hit_limit_by_ip(key, user_ip=user_ip):
        exceeded = True
    per_ip_and_uid_buckets.incr(key)

    return exceeded
