# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets


def hit_limit(email, uid):
    buckets = get_buckets(settings.VALIDATOR_EMAIL_SENT_PER_UID_AND_ADDRESS_COUNTER)
    return buckets.hit_limit(counter_id(email, uid))


def incr(email, uid):
    buckets = get_buckets(settings.VALIDATOR_EMAIL_SENT_PER_UID_AND_ADDRESS_COUNTER)
    return buckets.incr(counter_id(email, uid))


def counter_id(email, uid):
    return '%d/%s' % (uid, email)
