# -*- coding: utf-8 -*-
from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets
from passport.backend.core.counters.utils import is_trusted_country


def get_counter(user_ip):
    if is_trusted_country(user_ip):
        prefix = settings.AUTH_MAGIC_LINK_EMAIL_SENT_PER_IP_COUNTER
    else:
        prefix = settings.AUTH_MAGIC_LINK_EMAIL_SENT_PER_UNTRUSTED_IP_COUNTER
    return get_buckets(prefix)
