# -*- coding: utf-8 -*-

from collections import namedtuple
import logging

from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets


log = logging.getLogger(__name__)


RegKarmaStatus = namedtuple('RegKarmaStatus', 'is_bad status')


WHITE = RegKarmaStatus(False, '')
BLOCKED_GRAY = RegKarmaStatus(True, 'blocked_gray')
AMNISTED_GRAY = RegKarmaStatus(False, 'amnisted_gray')
BLOCKED_BLACK = RegKarmaStatus(True, 'blocked_black')


def get_bad_buckets():
    return get_buckets(settings.REGKARMA_BAD_COUNTER)


def get_good_buckets():
    return get_buckets(settings.REGKARMA_GOOD_COUNTER)


def get_status(user_ip):

    if not settings.REGKARMA_BAD_ENABLED:
        return WHITE

    if not get_bad_buckets().hit_limit_by_ip(user_ip):
        return WHITE

    if not settings.REGKARMA_GOOD_ENABLED:
        return BLOCKED_GRAY

    if get_good_buckets().hit_limit_by_ip(user_ip):
        return AMNISTED_GRAY

    return BLOCKED_BLACK


def incr_bad(user_ip):
    if settings.REGKARMA_BAD_ENABLED:
        return get_bad_buckets().incr(user_ip)
    return 0


def incr_good(user_ip):
    if settings.REGKARMA_BAD_ENABLED and settings.REGKARMA_GOOD_ENABLED:
        return get_good_buckets().incr(user_ip)
    return 0
