# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets


def get_per_ip_buckets():
    return get_buckets(settings.RESTORE_PER_IP_LIMIT_COUNTER)


def is_ip_limit_exceeded(ip, only_check=False, limit=None):
    per_ip_buckets = get_per_ip_buckets()
    is_limit_hit = per_ip_buckets.hit_limit_by_ip(ip, limit=limit)
    if not only_check:
        per_ip_buckets.incr(ip)
    return is_limit_hit
