# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets


def get_per_uid_buckets():
    return get_buckets(settings.RESTORE_SEMI_AUTO_COMPARE_PER_UID_LIMIT_COUNTER)


def get_per_ip_buckets():
    return get_buckets(settings.RESTORE_SEMI_AUTO_COMPARE_PER_IP_LIMIT_COUNTER)


def is_uid_limit_exceeded(uid, only_check=False):
    per_uid_buckets = get_per_uid_buckets()
    is_limit_hit = per_uid_buckets.hit_limit(uid)
    if not only_check:
        per_uid_buckets.incr(uid)
    return is_limit_hit


def is_ip_limit_exceeded(ip, only_check=False):
    per_ip_buckets = get_per_ip_buckets()
    is_limit_hit = per_ip_buckets.hit_limit_by_ip(ip)
    if not only_check:
        per_ip_buckets.incr(ip)
    return is_limit_hit
