# -*- coding: utf-8 -*-
from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets
from passport.backend.core.counters.utils import is_trusted_country


def get_counter(user_ip):
    if is_trusted_country(user_ip):
        prefix = settings.PHONE_CONFIRMATION_SMS_PER_IP_LIMIT_COUNTER
    else:
        prefix = settings.UNTRUSTED_PHONE_CONFIRMATION_SMS_PER_IP_LIMIT_COUNTER
    return get_buckets(prefix)


def get_registration_completed_with_phone_counter(user_ip):
    if is_trusted_country(user_ip):
        prefix = settings.REGISTRATION_COMPLETED_WITH_SMS_PER_IP_LIMIT_COUNTER
    else:
        prefix = settings.UNTRUSTED_REGISTRATION_COMPLETED_WITH_SMS_PER_IP_LIMIT_COUNTER
    return get_buckets(prefix)


def get_registration_sms_sent_counter(user_ip):
    return get_buckets(settings.REGISTRATION_SMS_SENT_PER_IP_LIMIT_COUNTER)


def get_auth_forwarding_by_sms_counter(user_ip):
    if is_trusted_country(user_ip):
        prefix = settings.AUTH_FORWARDING_SMS_PER_IP_LIMIT_COUNTER
    else:
        prefix = settings.UNTRUSTED_AUTH_FORWARDING_SMS_PER_IP_LIMIT_COUNTER
    return get_buckets(prefix)
