# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import (
    do_buckets_exist,
    get_buckets,
)


def exists(app_id):
    prefix = settings.PHONE_CONFIRMATION_SMS_PER_IP_FOR_APP_COUNTER_FMT % app_id
    return do_buckets_exist(prefix)


def get_counter(app_id):
    prefix = settings.PHONE_CONFIRMATION_SMS_PER_IP_FOR_APP_COUNTER_FMT % app_id
    return get_buckets(prefix)
