# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets


def get_per_ip_buckets():
    return get_buckets(settings.SOCIALREG_PER_IP_CAPTCHA_LIMIT_COUNTER)


def get_per_provider_buckets():
    return get_buckets(settings.SOCIALREG_PER_PROVIDER_CAPTCHA_LIMIT_COUNTER)


def is_required(user_ip, provider):
    required = False

    per_ip_buckets = get_per_ip_buckets()
    if per_ip_buckets.hit_limit_by_ip(user_ip):
        required = True
    per_ip_buckets.incr(user_ip)

    per_provider_buckets = get_per_provider_buckets()
    if per_provider_buckets.hit_limit(provider):
        required = True
    per_provider_buckets.incr(provider)

    return required
