# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets


def get_calls_bucket():
    return get_buckets(settings.UNCOMPLETEDREG_CALLS_CAPTCHA_LIMIT_COUNTER)


def get_per_ip_buckets():
    return get_buckets(settings.UNCOMPLETEDREG_PER_IP_CAPTCHA_LIMIT_COUNTER)


def is_required(user_ip):
    # Для IP считаем хиты, но чтобы
    # один плохой пользователь не мог испортить всем жизнь,
    # счетчик вызовов ручки регистрации увеличивается,
    # только если не достигнут лимит по IP.

    per_ip_buckets = get_per_ip_buckets()
    is_ip_limit_hit = per_ip_buckets.hit_limit_by_ip(user_ip)
    per_ip_buckets.incr(user_ip)
    if is_ip_limit_hit:
        return True

    calls_bucket = get_calls_bucket()
    is_calls_limit_hit = calls_bucket.hit_limit()
    calls_bucket.incr()
    if is_calls_limit_hit:
        return True

    return False
