# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings
from passport.backend.core.counters.buckets import get_buckets


def get_counter_buckets(check='ip', mode=None):
    if check == 'ip':
        prefix = settings.YAPIC_UPLOAD_PER_IP_LIMIT_COUNTER if mode is None else settings.YAPIC_DELETE_PER_IP_LIMIT_COUNTER
    else:
        prefix = settings.YAPIC_UPLOAD_PER_UID_LIMIT_COUNTER if mode is None else settings.YAPIC_DELETE_PER_UID_LIMIT_COUNTER
    return get_buckets(prefix)


def is_limit_upload_exceeded(user_ip, uid):
    exceeded = False

    per_ip_buckets = get_counter_buckets()
    if per_ip_buckets.hit_limit_by_ip(user_ip):
        exceeded = True
    per_ip_buckets.incr(user_ip)

    per_ip_and_uid_buckets = get_counter_buckets(check='uid')
    key = '%s:%s' % (user_ip, uid)
    if per_ip_and_uid_buckets.hit_limit_by_ip(key, user_ip=user_ip):
        exceeded = True
    per_ip_and_uid_buckets.incr(key)

    return exceeded


def is_limit_delete_exceeded(user_ip, uid):
    exceeded = False

    per_ip_buckets = get_counter_buckets(mode='delete')
    if per_ip_buckets.hit_limit_by_ip(user_ip):
        exceeded = True
    per_ip_buckets.incr(user_ip)

    per_ip_and_uid_buckets = get_counter_buckets(check='uid', mode='delete')
    key = '%s:%s' % (user_ip, uid)
    if per_ip_and_uid_buckets.hit_limit_by_ip(key, user_ip=user_ip):
        exceeded = True
    per_ip_and_uid_buckets.incr(key)

    return exceeded
