import mock
from passport.backend.core.test.test_utils import single_entrant_patch


@single_entrant_patch
class FakeKeyStorage(object):
    def __init__(self, key_number, key):
        self._key_number = key_number
        self._key = key
        self.mock_get_key = mock.patch(
            'passport.backend.core.crypto.key_storage.BaseKeyStorage.get_key',
            side_effect=lambda x=None: (self._key, self._key_number)
        )
        self.mock_get_key_number = mock.patch(
            'passport.backend.core.crypto.key_storage.BaseKeyStorage._get_key_number',
            side_effect=lambda: self._key_number
        )

    def set_key(self, key):
        self._key = key

    def start(self):
        self.mock_get_key.start()
        self.mock_get_key_number.start()

    def stop(self):
        self.mock_get_key_number.stop()
        self.mock_get_key.stop()

    def __del__(self):
        del self.mock_get_key_number
        del self.mock_get_key

    def __enter__(self):
        self.start()
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.stop()
