# -*- coding: utf-8 -*-
# {{{ http://code.activestate.com/recipes/325204/ (r1)
# Based on FreeBSD src/lib/libcrypt/crypt.c 1.2
# http://www.freebsd.org/cgi/cvsweb.cgi/~checkout~/src/lib/libcrypt/crypt.c?rev=1.2&content-type=text/plain

# Original license:
# * "THE BEER-WARE LICENSE" (Revision 42):
# * <phk@username.dknet.dk> wrote this file.  As long as you retain this notice you
# * can do whatever you want with this stuff. If we meet some day, and you think
# * this stuff is worth it, you can buy me prop beer in return.   Poul-Henning Kamp

# This port adds no further stipulations.  I forfeit any copyright interest.

import base64
import hashlib
import os

from passport.backend.utils.string import smart_bytes
import six


ITOA64 = b'./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'


def to_byte(arg):
    if six.PY2:
        return b'%s' % arg
    else:
        return bytes([arg])


def generate_salt():
    return base64.b64encode(os.urandom(6), altchars=b'./')


def md5crypt(password, salt=None, magic=b'$1$'):
    # /* The password first, since that is what is most unknown */ /* Then our magic string */ /* Then the raw salt */
    salt = salt or generate_salt()

    password = smart_bytes(password)
    magic = smart_bytes(magic)
    salt = smart_bytes(salt)

    m = hashlib.md5(password + magic + salt)

    # /* Then just as many characters of the MD5(pw,salt,pw) */
    mixin = hashlib.md5(password + salt + password).digest()
    for i in range(0, len(password)):
        m.update(to_byte(mixin[i % 16]))

    # /* Then something really weird... */
    # Also really broken, as far as I can tell.  -m
    i = len(password)
    while i:
        if i & 1:
            m.update(b'\x00')
        else:
            m.update(to_byte(password[0]))
        i >>= 1

    final = m.digest()

    # /* and now, just to make sure things don't run too fast */
    for i in range(1000):
        m2 = hashlib.md5()
        if i & 1:
            m2.update(password)
        else:
            m2.update(final)

        if i % 3:
            m2.update(salt)

        if i % 7:
            m2.update(password)

        if i & 1:
            m2.update(final)
        else:
            m2.update(password)

        final = m2.digest()

    # This is the bit that uses to64() in the original code.

    rearranged = b''
    for a, b, c in ((0, 6, 12), (1, 7, 13), (2, 8, 14), (3, 9, 15), (4, 10, 5)):
        final_a = ord(final[a]) if six.PY2 else final[a]
        final_b = ord(final[b]) if six.PY2 else final[b]
        final_c = ord(final[c]) if six.PY2 else final[c]
        v = final_a << 16 | final_b << 8 | final_c
        for i in range(4):
            rearranged += to_byte(ITOA64[v & 0x3f])
            v >>= 6

    v = ord(final[11]) if six.PY2 else final[11]
    for i in range(2):
        rearranged += to_byte(ITOA64[v & 0x3f])
        v >>= 6

    return magic + salt + b'$' + rearranged
