# -*- coding: utf-8 -*-
from passport.backend.core.dbmanager.manager import safe_execute_queries
from passport.backend.core.runner import BaseActionRunner


class EavReadingActionRunner(BaseActionRunner):
    def _execute(self, eavquery, retries=None, with_low_timeout=False):
        result_proxy = {}

        def _callback(result):
            result_proxy['value'] = eavquery.parse_query_result(result)
        safe_execute_queries(
            [(eavquery, _callback)],
            retries=retries,
            with_low_timeout=with_low_timeout,
        )
        return result_proxy.get('value')
