# -*- coding: utf-8 -*-

from passport.backend.core.dbmanager.manager import safe_execute_queries


def get_id_from_query_result(result):
    # SQLAlchemy или драйвер может вернуть 0 вместо нового ID, поэтому
    # явно проверяем и выбрасываем ошибку.
    new_id = result.inserted_primary_key[0]
    if not new_id:
        raise RuntimeError('SQLAlchemy or its subsystem has an error (inserted_primary_key[0] = %r)' % new_id)  # pragma: no cover
    return new_id


def _run_incr_id_query(query):
    query_response = {}

    def _callback(result):
        query_response['id'] = get_id_from_query_result(result)

    safe_execute_queries([(query, _callback)])

    return query_response['id']


def run_incr_id_query(query):
    # лишний уровень вложенности - для возможности мокать результат
    return _run_incr_id_query(query)
