from passport.backend.utils.time import (
    round_timestamp,
    zero_datetime,
)
import six
from sqlalchemy.types import (
    String,
    TIMESTAMP as _TIMESTAMP,
    TypeDecorator,
)


class ForceString(TypeDecorator):
    impl = String

    def process_bind_param(self, value, dialect):
        if value is None:
            return value
        return six.text_type(value)


class TIMESTAMP(TypeDecorator):
    impl = _TIMESTAMP

    def process_bind_param(self, value, dialect):
        value = round_timestamp(value)

        if dialect.name == u'mysql':
            if value is zero_datetime:
                value = str(zero_datetime)
        return value

    def result_processor(self, dialect, coltype):
        processor = super(TIMESTAMP, self).result_processor(dialect, coltype)
        if dialect.name == u'sqlite':
            return lambda value: zero_datetime if value.startswith('0000-') else processor(value)

        return processor
