# -*- coding: utf-8 -*-

from passport.backend.core.exceptions import BaseCoreError


class DBError(BaseCoreError):
    pass


class DBIntegrityError(DBError):
    """Нарушение ограничений уникальности записей в БД"""


class DBOperationalError(DBError):
    """Ошибки при выполнении запросов к БД"""


class DBDataError(DBError):
    """Ошибка валидации данных в БД"""
