# -*- coding: utf-8 -*-

from collections import namedtuple


_Diff = namedtuple('Diff', 'added changed deleted')


class Diff(_Diff):
    def get_changed_fields(self, fields_to_intersect_with=None):
        """
        Возвращает список всех измененных полей, пересеченный с all_fields_list.
        """
        fields = dict(self.changed)
        fields.update(self.deleted)
        fields.update(self.added)

        output = set(fields)
        if fields_to_intersect_with is not None:
            output.intersection_update(fields_to_intersect_with)

        return output

    def __bool__(self):
        return self != EmptyDiff

    __nonzero__ = __bool__


EmptyDiff = ({}, {}, {})
