# -*- coding: utf-8 -*-

from passport.backend.core.differ.types import Diff
from passport.backend.core.models.base import Model
from passport.backend.core.undefined import Undefined


def normalize_value(value):
    if isinstance(value, Model):
        return dict((k, v) for (k, v) in value if v is not Undefined)
    return value


def get_obj_id(o):
    if isinstance(o, Model):
        return o._id
    elif isinstance(o, dict):
        return o.get('_id', id(o))
    return id(o)


def model_as_dict(model):
    """Работаем с моделями как со словарями"""
    if model in (Undefined, None):
        return {}

    result = dict(model)
    result['_id'] = model._id
    return result


def slice_diff(difference, key):
    added, changed, deleted = difference
    ret_added = {}
    ret_changed = {}
    ret_deleted = {}
    if key in added:
        ret_added = added[key]
    if key in changed:
        ret_changed = changed[key]
    if key in deleted:
        ret_deleted = deleted[key]
    return Diff(ret_added, ret_changed, ret_deleted)
