# -*- coding: utf-8 -*-

from six import (
    iteritems,
    itervalues,
    string_types,
)


ATTRIBUTE_NAME_TO_TYPE = {
    # FIXME: Имя поля подразумевает datetime.datetime, однако в БД хранится time.time
    'account.registration_datetime': 1,
    'account.user_defined_login': 2,
    'account.is_disabled': 3,
    'account.global_logout_datetime': 4,
    'account.is_pdd_agreement_accepted': 6,
    'account.is_pdd_admin': 7,
    'account.is_betatester': 8,
    'account.is_corporate': 9,
    'account.is_vip': 10,
    'account.is_test': 11,
    'account.is_employee': 12,
    'account.is_maillist': 13,
    'account.default_email': 14,
    'person.contact_phone_number': 15,
    'account.display_name': 16,
    'karma.value': 17,
    'karma.activation_datetime': 18,
    'password.encrypted': 19,
    # FIXME: Имя поля подразумевает datetime.datetime, однако в БД хранится time.time
    'password.update_datetime': 20,
    'password.quality': 21,
    'password.forced_changing_reason': 22,
    'password.is_creating_required': 23,
    'password.is_strong_policy_enabled': 24,
    'hint.question.serialized': 25,
    # FIXME: Имя поля подразумевает зашифрованную строку, однако в БД хранится простой текст
    'hint.answer.encrypted': 26,
    'person.firstname': 27,
    'person.lastname': 28,
    'person.gender': 29,
    'person.birthday': 30,
    'person.country': 31,
    'person.city': 32,
    'person.timezone': 33,
    'person.language': 34,
    'subscription.mail.login_rule': 39,
    'subscription.fotki': 44,
    'subscription.cards': 45,
    'subscription.news': 46,
    'subscription.direct': 48,
    'subscription.spamooborona': 49,
    'subscription.balance': 50,
    'subscription.23': 52,
    'subscription.24': 53,
    'subscription.25': 54,
    'subscription.26': 55,
    'subscription.jabber.login_rule': 56,
    'subscription.29': 57,
    'subscription.30': 58,
    'subscription.31': 59,
    'subscription.37': 60,
    'subscription.38': 61,
    'subscription.39': 62,
    'subscription.40': 63,
    'subscription.41': 64,
    'subscription.wwwdgt.mode': 65,
    'subscription.disk.login_rule': 66,
    'subscription.47': 68,
    'subscription.48': 69,
    'subscription.49': 70,
    'subscription.50': 71,
    'subscription.51': 72,
    'subscription.52': 73,
    'subscription.53': 74,
    'subscription.54': 75,
    'subscription.55': 76,
    'subscription.57': 77,
    'subscription.cloud.is_active': 78,
    'subscription.60': 79,
    'subscription.cloud.is_paid': 80,
    'subscription.76': 81,
    'subscription.cloud.use_mobile': 82,
    'subscription.78': 83,
    'subscription.cloud.use_desktop': 84,
    'subscription.cloud.use_web': 85,
    'subscription.666': 86,
    'subscription.667': 87,
    'subscription.83': 89,
    'subscription.84': 90,
    'subscription.85': 91,
    'subscription.86': 92,
    'subscription.87': 93,
    'account.is_ad_campaign_participant': 94,
    'subscription.88': 95,
    'subscription.90': 96,
    'subscription.91': 97,
    'avatar.default': 98,
    'account.browser_key': 101,
    'subscription.cloud.is_migrant': 103,
    'account.totp.secret': 104,
    'account.totp.check_time': 106,
    'account.enable_app_password': 107,
    'subscription.video.search': 108,
    'subscription.bugbounty': 109,
    'phones.secure': 110,
    'phones.default': 111,
    'subscription.avia': 112,
    'subscription.mailapp2014.androidphone': 113,
    'subscription.mailapp2014.androidtablet': 114,
    'subscription.mailapp2014.iphone': 115,
    'subscription.mailapp2014.ipad': 116,
    'subscription.mailapp2014.ipadbirdseye': 117,
    'account.totp.failed_pin_checks_count': 118,
    'subscription.kinopoisk': 119,
    'account.totp.update_datetime': 123,

    'subscription.rabota': 124,
    'subscription.rabota.employee': 125,
    'subscription.rabota.blue_collar': 126,
    'subscription.rabota.employer': 127,
    'subscription.rabota.mobile_app': 128,
    'subscription.rabota.mobile_site': 129,
    'subscription.realty': 120,
    'subscription.realty_agent': 121,
    'subscription.realty_moderator': 130,
    'subscription.taxi': 131,

    'account.is_shared': 132,
    'account.show_2fa_promo': 133,

    'revoker.tokens': 134,
    'revoker.app_passwords': 135,
    'revoker.web_sessions': 136,

    'subscription.realty.app.ios': 137,
    'subscription.realty.app.android': 138,
    'subscription.site_search': 139,

    'account.auth_email_datetime': 140,
    'account.failed_auth_challenge_checks_counter': 141,

    'subscription.toloka': 142,
    'account.totp.junk_secret': 143,
    'account.audience_on': 146,

    'account.migrated_from_phonishes': 144,
    'account.migrated_to': 145,

    'subscription.telephony': 148,

    'account.is_music_complete_phonish': 149,
    'account.is_billing_complete_phonish': 150,
    'account.is_phonish_completion_finished': 151,

    'subscription.musicpremium': 152,
    'account.deletion_operation_started_at': 153,
    'account.is_connect_admin': 154,

    'account.rfc_totp.secret': 155,
    'account.rfc_totp.check_time': 156,

    'account.is_money_agreement_accepted': 157,
    'account.additional_data_asked': 158,
    'account.additional_data_ask_next_datetime': 159,
    'account.enable_search_by_phone_alias': 165,

    # атрибуты Плюса
    'account.plus.enabled': 160,
    'account.plus.trial_used_ts': 161,
    'account.plus.subscription_stopped_ts': 162,
    'account.plus.subscription_expire_ts': 163,
    'account.plus.next_charge_ts': 164,
    # Подписка на Кинопоиск
    'account.plus.ott_subscription': 167,

    'account.creator_uid': 166,

    'account.external_organization_ids': 168,

    # Takeout
    'takeout.extract_in_progress_since': 169,
    'takeout.archive_s3_key': 170,
    'takeout.archive_password': 171,
    'takeout.archive_created_at': 172,
    'takeout.fail_extract_at': 173,
    # Разрешение пользоваться takeout
    'takeout.subscription': 184,

    # PASSP-23241 атрибут, меняющий вычисление public_name на стороне ЧЯ
    'person.dont_use_displayname_as_public_name': 174,

    # роль в семье Яндекс.Плюс
    'account.plus.family_role': 175,

    # сид Драйва
    'account.drive_subscription': 176,

    'account.is_easily_hacked': 177,

    # сид Инвестиций
    'investments.is_registered': 178,

    # неймспейс, в котором живёт фониш
    'account.phonish_namespace': 179,

    # PASSP-25400 Билинговые фичи
    'account.billing_features': 180,

    # PASSP-25526 Вход по мессенджеру/волшебному письму разрешен/запрещен
    'account.magic_link_login_forbidden': 181,
    # Вход по Qr коду разрешен/запрещен
    'account.qr_code_login_forbidden': 182,
    # Вход по sms разрешен/запрещен
    'account.sms_code_login_forbidden': 187,

    'person.show_fio_in_public_name': 185,
    'account.user_defined_public_id': 186,

    # Обязательно требовать челлендж
    'account.force_challenge': 188,

    'account.hide_yandex_domains_emails': 189,

    # сид телемоста
    'account.telemost_subscription': 190,

    'account.plus.cashback_enabled': 194,
    'password.forced_changing_time': 195,
    'account.is_verified': 196,

    # сид почта про
    'account.mailpro_subscription': 197,
    'account.mailpro_on_subscription': 198,
    'account.mailpro_off_subscription': 199,

    'account.sms_2fa_on': 200,
    'account.forbid_disabling_sms_2fa': 201,

    # класс возрастных ограничений ребёнкиша
    'account.content_rating_class': 202,
    'account.music_content_rating_class': 205,
    'account.video_content_rating_class': 206,

    'subscription.mail.status': 203,

    # Разрешить пользоваться удалением данных в takeout
    'takeout.delete.subscription': 204,

    # Отписки от почтовых рассылок
    'account.unsubscribed_from_maillists': 207,

    'account.personal_data_public_access_allowed': 208,
    'account.personal_data_third_party_processing_allowed': 209,

    # Признак детского аккаунта
    'account.is_child': 210,

    'account.scholar_password': 211,

    # "Глобальные" имя и фамилия пользователя на стаффе только на английском
    'person.firstname_global': 212,
    'person.lastname_global': 213,

    # Индульгенция на проверку слитого пароля PASSP-34095
    'password.pwn_forced_changing_suspended_at': 214,

    'account.bank_subscription': 215,

    # Уровень подписки Плюс
    'account.plus.subscription_level': 216,

    # Флаг заморозки подписки Плюс
    'account.plus.is_frozen': 217,

    # Возможность платить семейной картой
    'account.family_pay.enabled': 218,

    # Согласие на передачу документов из / в ID
    'account.is_documents_agreement_accepted': 219,

    # Состояние плюсового подписчика
    'account.plus.subscriber_state': 220,

    # Список device_id, на которых настроен Ключ
    'account.totp.yakey_device_ids': 221,

    'account.is_dzen_sso_prohibited': 223,
    'account.last_child_family': 224,
    'account.can_manage_children': 225,

    # виртуальные атрибуты
    'account.2fa_on': 1003,
    'account.have_password': 1005,
    'account.normalized_login': 1008,
    'account.is_available': 1009,
    'account.totp.secret_ids': 1010,
    'account.have_organization_name': 1011,
    'account.totp.pin_length': 1012,
    'account.rfc_2fa_on': 1014,
    'account.have_plus': 1015,
}
ATTRIBUTE_TYPE_TO_NAME = {
    attr_type: name
    for name, attr_type in iteritems(ATTRIBUTE_NAME_TO_TYPE)
}

# Обратная совместимость некоторых подписок
ATTRIBUTE_NAME_TO_TYPE.update({
    'subscription.102': 6,             # account.is_pdd_agreement_accepted
    'subscription.104': 7,             # account.is_pdd_admin
    'subscription.668': 8,             # account.is_betatester
    'subscription.670': 9,             # account.is_corporate
    'subscription.671': 10,            # account.is_vip
    'subscription.672': 11,            # account.is_test
    'subscription.1000': 12,           # account.is_employee
    'subscription.100': 23,            # password.is_creating_required
    'subscription.67': 24,             # password.is_strong_policy_enabled
    'subscription.2.login_rule': 39,   # subscription.mail.login_rule
    'subscription.5': 44,              # subscription.fotki
    'subscription.6': 45,              # subscription.cards
    'subscription.9': 46,              # subscription.news
    'subscription.14': 48,             # subscription.direct
    'subscription.17': 49,             # subscription.spamooborona
    'subscription.19': 50,             # subscription.balance
    'subscription.27': 56,             # subscription.jabber
    'subscription.27.login_rule': 56,  # subscription.jabber.login_rule
    'subscription.42': 65,             # subscription.wwwdgt
    'subscription.44': 66,             # subscription.disk
    'subscription.44.login_rule': 66,  # subscription.disk.login_rule
    'subscription.59': 78,             # subscription.cloud.is_active
    'subscription.64': 80,             # subscription.cloud.is_paid
    'subscription.77': 82,             # subscription.cloud.use_mobile
    'subscription.80': 84,             # subscription.cloud.use_desktop
    'subscription.81': 85,             # subscription.cloud.use_web
    'subscription.93': 103,            # subscription.cloud.is_migrant
})

# При создании этих атрибутов в первый раз будет выполняться строгий insert-запрос.
# Это сделано во избежание гонок. Когда еще один такой же запрос пришел, а запись уже создана
# в БД, она может быть уже обновлена потребителем. В этом случае нельзя выполнять запрос с суффиксом
# "ON DUPLICATE KEY" - лучше упасть с ошибкой уровня БД при выполнении повторного запроса вставки
ATTRIBUTES_TYPES_NEED_INSERT_INTO_ON_CREATE = set([
])

# По тем же причинам, при обновлении этих атрибутов, нужно делать обновление на новое значение
# только в том случае, когда в БД хранится ожидаемое значение.
ATTRIBUTES_TYPES_NEED_INSERT_WITH_IF_EQUALS_ON_UPDATE = set([
])

ATTRIBUTES_TYPES_ALLOW_APPEND = set([
    ATTRIBUTE_NAME_TO_TYPE['account.browser_key'],
    ATTRIBUTE_NAME_TO_TYPE['account.migrated_from_phonishes'],
])

ATTRIBUTES_TYPES_ALLOW_INCREMENT = set([
    ATTRIBUTE_NAME_TO_TYPE['account.totp.failed_pin_checks_count'],
])

ALLOW_ZERO_VALUE_ATTRS = set(ATTRIBUTE_NAME_TO_TYPE[attr_name] for attr_name in [
    'account.content_rating_class',
    'account.music_content_rating_class',
    'account.video_content_rating_class',

    # Обновление login_rule делается только на следующих сидах
    'subscription.disk.login_rule',
    'subscription.jabber.login_rule',
    'subscription.mail.login_rule',
])


ALIAS_NAME_TO_TYPE = {
    'portal': 1,
    'mail': 2,
    'narodmail': 3,
    'lite': 5,
    'social': 6,
    'pdd': 7,
    'pddalias': 8,
    'altdomain': 9,
    'narodspec': 66,  # не используется, но номер зарезервирован
    'phonish': 10,
    'phonenumber': 11,
    'mailish': 12,
    'yandexoid': 13,
    'kinopoisk': 15,
    'uber': 16,
    'yambot': 17,
    'kolonkish': 18,
    'public_id': 19,
    'old_public_id': 20,
    'neophonish': 21,
    'kiddish': 22,
    'scholar': 23,
    'federal': 24,
    'bank_phonenumber': 25,
}

EXTENDED_ATTRIBUTES_PHONE_TYPE = 1
EXTENDED_ATTRIBUTES_PHONE_NAME_TO_TYPE_MAPPING = {
    'number': 1,
    'created': 2,
    'bound': 3,
    'confirmed': 4,
    'admitted': 5,
    'secured': 6,
    # виртуальные атрибуты
    'is_default': 107,
    'is_bank': 109,
}
EXTENDED_ATTRIBUTES_PHONE_TYPE_TO_NAME_MAPPING = {
    type_: name
    for name, type_ in iteritems(EXTENDED_ATTRIBUTES_PHONE_NAME_TO_TYPE_MAPPING)
}

EXTENDED_ATTRIBUTES_EMAIL_TYPE = 2
EXTENDED_ATTRIBUTES_EMAIL_NAME_TO_TYPE_MAPPING = {
    'address': 1,
    'created': 2,
    'confirmed': 3,
    'bound': 4,
    'is_rpop': 5,
    'is_unsafe': 6,
    'is_silent': 7,
}
EXTENDED_ATTRIBUTES_EMAIL_TYPE_TO_NAME_MAPPING = {
    type_: name
    for name, type_ in iteritems(EXTENDED_ATTRIBUTES_EMAIL_NAME_TO_TYPE_MAPPING)
}

EXTENDED_ATTRIBUTES_WEBAUTHN_TYPE = 3
EXTENDED_ATTRIBUTES_WEBAUTHN_NAME_TO_TYPE_MAPPING = {
    'external_id': 1,
    'public_key': 2,
    'sign_count': 3,
    'device_name': 4,
    'created': 5,
    'relying_party_id': 6,
    'os_family_id': 7,
    'browser_id': 8,
    'is_device_mobile': 9,
    'is_device_tablet': 10,
}
EXTENDED_ATTRIBUTES_WEBAUTHN_TYPE_TO_NAME_MAPPING = {
    type_: name
    for name, type_ in iteritems(EXTENDED_ATTRIBUTES_WEBAUTHN_NAME_TO_TYPE_MAPPING)
}

EXTENDED_ATTRIBUTES_NAME_TO_TYPE_MAPPING = {
    EXTENDED_ATTRIBUTES_PHONE_TYPE: EXTENDED_ATTRIBUTES_PHONE_NAME_TO_TYPE_MAPPING,
    EXTENDED_ATTRIBUTES_EMAIL_TYPE: EXTENDED_ATTRIBUTES_EMAIL_NAME_TO_TYPE_MAPPING,
    EXTENDED_ATTRIBUTES_WEBAUTHN_TYPE: EXTENDED_ATTRIBUTES_WEBAUTHN_NAME_TO_TYPE_MAPPING,
}

EXTENDED_ATTRIBUTES_ENTITY_NAME_TO_TYPE_MAPPING = dict(
    email=EXTENDED_ATTRIBUTES_EMAIL_TYPE,
    phone=EXTENDED_ATTRIBUTES_PHONE_TYPE,
    webauthn=EXTENDED_ATTRIBUTES_WEBAUTHN_TYPE,
)

EXTENDED_ATTRIBUTES_TYPE_TO_NAME_MAPPING = {}
for type_, mapping in iteritems(EXTENDED_ATTRIBUTES_NAME_TO_TYPE_MAPPING):
    new_mapping = {v: k for k, v in iteritems(mapping)}
    EXTENDED_ATTRIBUTES_TYPE_TO_NAME_MAPPING[type_] = new_mapping


# Отображение кода атрибута к SID'у сервиса, необходимое для работы с
# добавлением "subscription.suid.<SID>" к ответу blackbox'а при
# наличии определенных атрибутов в ответе.
SUBSCRIPTION_ATTR_TO_SID = {
    108: 95,  # subscription.video.search -> подписка на "Видеопоиск"
    109: 96,  # subscription.bugbounty -> маркировка участников "Охоты"
    112: 97,  # subscription.avia -> подписка на "Авиабилеты"
    113: 201,  # subscription.mailapp2014.androidphone
    114: 202,  # subscription.mailapp2014.androidtablet
    115: 203,  # subscription.mailapp2014.iphone
    116: 204,  # subscription.mailapp2014.ipad
    117: 205,  # subscription.mailapp2014.ipadbirdseye
    119: 98,  # subscription.kinopoisk
    120: 73,  # subscription.realty
    121: 106,  # subscription.realty_agent
    130: 113,  # subscription.realty_moderator
    124: 72,  # subscription.rabota
    125: 108,  # subscription.rabota.employee
    126: 109,  # subscription.rabota.blue_collar
    127: 110,  # subscription.rabota.employer
    128: 111,  # subscription.rabota.mobile_app
    129: 112,  # subscription.rabota.mobile_site
    131: 114,  # subscription.taxi
    137: 206,  # subscription.realty.app.ios
    138: 207,  # subscription.realty.app.android
    139: 56,   # subscription.site_search
    142: 116,  # subscription.toloka
    148: 117,  # subscription.telephony
    152: 208,  # subscription.musicpremium
    176: 118,  # drive
    178: 119,  # investments
    190: 121,  # telemost
    197: 122,  # mailpro
    198: 123,  # mailpro_on
    199: 124,  # mailpro_off
    215: 125,  # bank
}
# Обратное отображение для быстрого поиска соответствующего подписке атрибута.
SID_TO_SUBSCRIPTION_ATTR = dict((v, k) for k, v in iteritems(SUBSCRIPTION_ATTR_TO_SID))


def attr_name_exists(attr_name):
    return attr_name in ATTRIBUTE_NAME_TO_TYPE


def ext_attr_name_exists(entity_type, attr_name):
    return attr_name in EXTENDED_ATTRIBUTES_NAME_TO_TYPE_MAPPING.get(entity_type, {})


def alias_name_exists(alias_name):
    return alias_name in ALIAS_NAME_TO_TYPE


def get_attr_type(attr_name):
    """
    Проверяет что передано допустимое имя атрибута, возвращает его тип;
    Если передано число, проверяет что оно допустимо и возвращает его если да;
    Если передана строка, содержащая число - конвертирует в int, делает проверку
    :param attr_name: (str or int) Имя или тип атрибута
    :return: (int) Тип атрибута
    """
    is_int = isinstance(attr_name, int)
    is_str = isinstance(attr_name, string_types)
    if is_int or (is_str and attr_name.isdigit()):
        attr_type = int(attr_name)
        if attr_type not in itervalues(ATTRIBUTE_NAME_TO_TYPE):
            raise KeyError('No such blackbox attribute type %d' % attr_type)

        return attr_type

    if not attr_name_exists(attr_name):
        raise KeyError('No such blackbox attribute with name %s' % attr_name)

    return ATTRIBUTE_NAME_TO_TYPE[attr_name]


def get_attr_name(attr_type):
    """Преобразует тип атрибута в имя."""
    attr_type = int(attr_type)
    try:
        return ATTRIBUTE_TYPE_TO_NAME[attr_type]
    except KeyError:
        raise KeyError(u'No such blackbox attribute type %d' % attr_type)
