# -*- coding: utf-8 -*-
from passport.backend.core.conf import settings
from passport.backend.core.cookies.yandexuid import (
    CookieYandexuidUnpackError,
    parse_yandexuid_timestamp,
)
from passport.backend.core.env_profile.profile import EnvProfileV1
from passport.backend.core.geobase import Region


def make_profile_from_raw_data(ip, yandexuid, user_agent_info, is_mobile=False, device_id=None, am_version=None,
                               cloud_token=None, **kwargs):
    ip = str(ip)
    region_info = Region(ip=ip)

    browser_name = None
    os_name = None
    os_version = None
    if user_agent_info:
        browser_name = user_agent_info.get('BrowserName')
        os_name = user_agent_info.get('OSName', user_agent_info.get('OSFamily'))
        os_version = user_agent_info.get('OSVersion')  # тут могут прийти буквы, судя по доке?

    try:
        timestamp = parse_yandexuid_timestamp(yandexuid)
    except CookieYandexuidUnpackError:
        timestamp = None

    raw_env = {
        'user_agent_info': user_agent_info,
        'ip': ip,
        'yandexuid': yandexuid,
    }
    if is_mobile:
        raw_env.update(is_mobile=is_mobile)
    if device_id:
        raw_env.update(device_id=device_id)
    if am_version:
        raw_env.update(am_version=am_version)
    if cloud_token:
        raw_env.update(cloud_token=cloud_token)

    return EnvProfileV1(
        AS_list=region_info.AS_list,
        country_id=region_info.country['id'] if region_info.country else None,
        city_id=region_info.city['id'] if region_info.city else None,
        browser_id=settings.BROWSER_ENCODE.get(browser_name) or None,
        os_id=settings.OS_ENCODE.get(
            (os_name, os_version),
            settings.OS_DUMB_ENCODE.get(os_name),
        ) or None,
        yandexuid_timestamp=timestamp,
        raw_env=raw_env,
        is_mobile=is_mobile or None,
        device_id=device_id,
        am_version=am_version,
        cloud_token=cloud_token,
        **kwargs
    )
