# -*- coding: utf-8 -*-
from passport.backend.utils.string import smart_unicode
import six


@six.python_2_unicode_compatible
class BaseCoreError(Exception):
    """Суперкласс для всех ядерных ошибок"""

    def __str__(self):
        if not self.args:
            return self.__class__.__name__
        elif len(self.args) == 1:
            return smart_unicode(self.args[0])
        else:
            return smart_unicode(self.args)


class WrongHostError(BaseCoreError):
    """Запросы с данного хоста запрещены"""


class InvalidIpHeaderError(BaseCoreError):
    """Некорректный IP в заголовке"""


class ValueChanged(BaseCoreError):
    """Это исключение поднимается, если требуется уведомить клиента об изменении значения в процессе валидации"""

    def __init__(self, code, msg, value, field):
        self.code = code
        self.msg = msg
        self.value = value
        self.field = field

        self.error_list = None
        self.error_dict = None


class UnknownUid(BaseCoreError):
    pass


__all__ = (
    'BaseCoreError',
    'WrongHostError',
    'InvalidIpHeaderError',
    'ValueChanged',
    'UnknownUid',
)
