# -*- coding: utf-8 -*-

import mock
from passport.backend.core.geobase.geobase import (
    Geobase,
    Region,
)
from passport.backend.utils.string import smart_str


class FakeRegion(object):
    def __init__(self):
        self.__patches = [
            mock.patch.object(Geobase, 'regions', mock.Mock(side_effect=self.get_regions)),
            mock.patch.object(Region, '__new__', mock.Mock(side_effect=self.build_region)),
        ]
        self._ip_to_region = dict()

    def set_region_for_ip(self, ip, region):
        defaults = dict(
            AS_list=['AS1'],
            country=dict(
                id=84,
                short_en_name='ru',
                timezone='Europe/Moscow',
            ),
            city={'id': 102630},
            name='region',
        )
        for key in defaults:
            region.setdefault(key, defaults[key])
        self._ip_to_region[smart_str(ip)] = mock.Mock(**region)

    def build_region(self, cls, ip=None, tld=None, id=None, geobase=None):
        if ip:
            region = self._ip_to_region.get(smart_str(ip))
        elif id:
            region = self._ip_to_region.get(smart_str(id))
        else:
            region = None

        return region or object.__new__(cls)

    def get_regions(self, ip):
        return [dict(id=smart_str(ip))]

    def start(self):
        for patch in self.__patches:
            patch.start()

    def stop(self):
        for patch in reversed(self.__patches):
            patch.stop()
