# -*- coding: utf-8 -*-

from collections import defaultdict

import mock
from passport.backend.core.grants.grants_config import GrantsConfig
from passport.backend.core.lazy_loader import LazyLoader
from passport.backend.core.test.test_utils import single_entrant_patch
from passport.backend.core.test.test_utils.mock_objects import mock_grants


@single_entrant_patch
class FakeGrants(object):
    def __init__(self):
        self._mock = mock.Mock()
        self._patch_read_grants = mock.patch.object(
            GrantsConfig,
            '_read_configs',
            self._mock,
        )

    def start(self):
        self._patch_read_grants.start()
        LazyLoader.flush(instance_name='GrantsConfig')

    def stop(self):
        self._patch_read_grants.stop()

    def __enter__(self):
        self.start()
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.stop()

    def set_grants_return_value(self, value):
        self._mock.return_value = value

    def set_grants_side_effect(self, fn):
        self._mock.side_effect = fn

    def set_grant_list(self, grant_list):
        """
        Задаёт разрешения для потребителя dev пришедшего из 127.0.0.1

        grant_list -- это список разрешений, например,
        ['password.use_for_web_only', 'account.global_logout']
        """
        grants = defaultdict(list)
        for grant in grant_list:
            sys_name, grant_name = grant.split('.')
            grants[sys_name].append(grant_name)
        self.set_grants_return_value(mock_grants(
            consumer=u'dev',
            grants=grants,
            networks=['127.0.0.1'],
        ))
