# -*- coding: utf-8 -*-


class GlobalLogoutParser(object):
    def parse(self, raw_event):
        if raw_event.data.get('info.glogout'):
            return {
                'type': 'global_logout',
            }


class WebSessionsRevoked(object):
    def parse(self, raw_event):
        if raw_event.data.get('info.web_sessions_revoked'):
            return {
                'type': 'web_sessions_revoked',
            }


class TokensRevoked(object):
    def parse(self, raw_event):
        if raw_event.data.get('info.tokens_revoked'):
            return {
                'type': 'tokens_revoked',
            }


class AppPasswordsRevoked(object):
    def parse(self, raw_event):
        # При включении ПП всегда отзываются текущие пароли приложений, но мы писать это в
        # журнале не хотим, см. PASSP-14765.
        action = raw_event.data.get('action', '')
        if action != 'app_passwords.activate' and raw_event.data.get('info.app_passwords_revoked'):
            return {
                'type': 'app_passwords_revoked',
            }
