# -*- coding: utf-8 -*-
from passport.backend.core.historydb.account_history.event_parsers.app_password import AppPasswordEventParser
from passport.backend.core.historydb.account_history.event_parsers.base import (
    determine_event_type,
    HistoryDbParsedEvent,
)
from passport.backend.core.historydb.account_history.event_parsers.email import (
    EmailNewEventParser,
    EmailOldAddEventParser,
    EmailOldDeleteEventParser,
    EmailRestoreFlushEventParser,
)
from passport.backend.core.historydb.account_history.event_parsers.glogout import (
    AppPasswordsRevoked,
    GlobalLogoutParser,
    TokensRevoked,
    WebSessionsRevoked,
)
from passport.backend.core.historydb.account_history.event_parsers.hint import HintEventParser
from passport.backend.core.historydb.account_history.event_parsers.password import PasswordChangeParser
from passport.backend.core.historydb.account_history.event_parsers.personal_data import PersonalDataParser
from passport.backend.core.historydb.account_history.event_parsers.phone import PhoneEventParser
from passport.backend.core.historydb.account_history.event_parsers.restore import RestoreEventParser
from passport.backend.core.historydb.account_history.event_parsers.totp import TotpEventParser


PARSERS = [
    RestoreEventParser(),
    PhoneEventParser(),
    PersonalDataParser(),
    GlobalLogoutParser(),
    AppPasswordsRevoked(),
    TokensRevoked(),
    WebSessionsRevoked(),
    PasswordChangeParser(),
    EmailOldAddEventParser(),
    EmailOldDeleteEventParser(),
    EmailNewEventParser(),
    EmailRestoreFlushEventParser(),
    AppPasswordEventParser(),
    TotpEventParser(),
    HintEventParser(),
]


def parse_event(event):
    parsed_event = HistoryDbParsedEvent.from_historydb_event(event)
    for parser in PARSERS:
        section = parser.parse(event)
        if section:
            parsed_event.actions.append(section)
    if parsed_event.actions:
        parsed_event.event_type = determine_event_type(parsed_event, event)
        return parsed_event
