# -*- coding: utf-8 -*-

from passport.backend.core.types.display_name import DisplayName


DISPLAY_NAME_FORMAT = {
    1: 'passport',
    2: 'social',
    3: 'template',
}


def format_display_name(display_name):
    dn = DisplayName()
    try:
        dn.set(display_name)
    except ValueError:
        # unknown prefix или отсутствие префикса
        return 'unknown', display_name
    else:
        return DISPLAY_NAME_FORMAT.get(dn.format, 'unknown'), dn.name


class PersonalDataParser(object):
    def parse(self, raw_event):
        action = raw_event.data.get('action')
        if action not in {None, 'person', 'questions_set', 'questions_change', 'complete_pdd'}:
            return
        changed_fields = []
        retval = {
            'type': 'personal_data',
        }
        data = {}
        known_params = {
            'firstname',
            'lastname',
            'display_name',
            'birthday',
            'tz',
            'country',
            'city',
            'sex',
        }
        for key, value in raw_event.data.items():
            info, _dot, param = key.partition('.')
            if info != 'info':
                continue
            if param in known_params:
                # display_name надо парсить, т.к. там может быть закодирована доп. информация
                # про социализм и т.п.
                if param == 'display_name':
                    display_name_format, value = format_display_name(value)
                    data['display_name_format'] = display_name_format
                data[param] = value
                changed_fields.append(param)
        if changed_fields:
            changed_fields.sort()
            retval['changed_fields'] = changed_fields
            retval.update(data)
            return retval
