# -*- coding: utf-8 -*-
import re

from passport.backend.core.types.email.email import (
    mask_email_for_challenge,
    unicode_email,
)
from passport.backend.core.types.phone_number.phone_number import (
    InvalidPhoneNumber,
    mask_phone_number,
    PhoneNumber,
)


RESTORE_PREFIX = 'restore_'
RE_RESTORE_SCENARIO = re.compile(r'^restore_passed_by_(\w+)$')


class RestoreEventParser(object):
    def parse(self, raw_event):
        action = raw_event.data.get('action')
        if not action or not action.startswith(RESTORE_PREFIX):
            return
        passed_by = RE_RESTORE_SCENARIO.match(raw_event.data['action'])
        if passed_by:
            retval = {
                'type': 'restore',
                'restore_by': passed_by.groups()[0],
            }
            used_phone_number = raw_event.data.get('info.used_phone')
            if used_phone_number:
                try:
                    used_phone_number = PhoneNumber.parse(used_phone_number, allow_impossible=True).international
                except InvalidPhoneNumber:
                    pass
                finally:
                    retval['phone'] = mask_phone_number(used_phone_number)
            used_email = raw_event.data.get('info.used_email')
            if used_email:
                retval['email'] = mask_email_for_challenge(unicode_email(used_email))
            return retval
