# -*- coding: utf-8 -*-


class TotpEventParser(object):
    def parse(self, raw_event):
        action = raw_event.data.get('action')
        if action == 'enable_otp' and raw_event.data.get('info.totp') == 'enabled':
            return {
                'type': 'totp_enabled',
            }
        elif action == 'migrate_otp':
            return {
                'type': 'totp_migrated',
            }
        elif action == 'disable_otp' and raw_event.data.get('info.totp') == 'disabled':
            return {
                'type': 'totp_disabled',
            }
        else:
            totp_update_time = 'info.totp_update_time'
            if totp_update_time in raw_event.data and raw_event.data[totp_update_time] is None:
                return {
                    'type': 'totp_disabled',
                }
