# -*- coding: utf-8 -*-

from passport.backend.core.historydb.analyzer.event_handlers.account_state import (
    AccountCreateDeleteHandler,
    AccountEnabledStatusHandler,
    RegistrationEnvHandler,
)
from passport.backend.core.historydb.analyzer.event_handlers.email import ConfirmedEmailEventHandler
from passport.backend.core.historydb.analyzer.event_handlers.other import (
    BirthdayEventHandler,
    NamesEventHandler,
    SimpleEventHandler,
)
from passport.backend.core.historydb.analyzer.event_handlers.password import PasswordChangeHandler
from passport.backend.core.historydb.analyzer.event_handlers.phone import PhoneEventHandler
from passport.backend.core.historydb.analyzer.event_handlers.question_answer import QuestionAnswerMappingHandler
from passport.backend.core.historydb.analyzer.event_handlers.restore import (
    RestorePassedAttemptsHandler,
    RestoreSemiAutoAttemptsHandler,
)
from passport.backend.core.historydb.events import (
    EVENT_APP_KEY_INFO,
    EVENT_INFO_FIRSTNAME,
    EVENT_INFO_HINTA,
    EVENT_INFO_HINTQ,
    EVENT_INFO_LASTNAME,
    EVENT_INFO_PASSWORD,
    EVENT_USERINFO_FT,
)


KWARGS_TO_HANDLERS_EVENTS = {
    'names': (
        SimpleEventHandler,
        (EVENT_INFO_FIRSTNAME, EVENT_INFO_LASTNAME, EVENT_USERINFO_FT),
    ),
    'app_key_info': (
        SimpleEventHandler,
        (EVENT_APP_KEY_INFO,),
    ),
    'grouped_names': (
        NamesEventHandler,
        NamesEventHandler.events,
    ),
    'birthdays': (
        BirthdayEventHandler,
        BirthdayEventHandler.events,
    ),
    'registration_env': (
        RegistrationEnvHandler,
        RegistrationEnvHandler.events,
    ),
    'account_create_delete_events': (
        AccountCreateDeleteHandler,
        AccountCreateDeleteHandler.events,
    ),
    'questions': (
        SimpleEventHandler,
        (EVENT_INFO_HINTQ, EVENT_USERINFO_FT),
    ),
    'answers': (
        SimpleEventHandler,
        (EVENT_INFO_HINTA, EVENT_USERINFO_FT),
    ),
    'question_answer_mapping': (
        QuestionAnswerMappingHandler,
        QuestionAnswerMappingHandler.events,
    ),
    'confirmed_emails': (
        ConfirmedEmailEventHandler,
        ConfirmedEmailEventHandler.events,
    ),
    'confirmed_phones': (
        PhoneEventHandler,
        PhoneEventHandler.events,
    ),
    'restore_passed_attempts': (
        RestorePassedAttemptsHandler,
        RestorePassedAttemptsHandler.events,
    ),
    'restore_semi_auto_attempts': (
        RestoreSemiAutoAttemptsHandler,
        RestoreSemiAutoAttemptsHandler.events,
    ),
    'password_changes': (
        PasswordChangeHandler,
        PasswordChangeHandler.events,
    ),
    'password_hashes': (
        SimpleEventHandler,
        (EVENT_INFO_PASSWORD,),
    ),
    'account_enabled_status': (
        AccountEnabledStatusHandler,
        AccountEnabledStatusHandler.events,
    ),
}
