# -*- coding: utf-8 -*-

from passport.backend.core.historydb.events import (
    ACTION_ACCOUNT_CHANGE_PASSWORD,
    ACTION_ACCOUNT_CREATE_PREFIX,
    ACTION_ACCOUNT_DELETE,
    ACTION_ACCOUNT_PASSWORD,
    ACTION_ACCOUNT_REGISTER_PREFIX,
    ACTION_RESTORE_PASSED_BY_METHOD_PREFIX,
    ACTION_RESTORE_SUPPORT_LINK_CREATED,
    EVENT_ACTION,
    EVENT_INFO_ENA,
    EVENT_INFO_KARMA,
    EVENT_INFO_KARMA_PREFIX,
    EVENT_SID_LOGIN_RULE,
)
from six import iteritems


def get_origin_info_from_event(event):
    """
    Как в общем случае получаем информацию об окружении:
    1) timestamp есть в каждом событии, т.к. является частью ключа HBase
    2) user_ip есть в большинстве событий, за исключением каких-либо сбоев
    3) yandexuid есть во всех событиях перлового Паспорта; в python-API будет писаться только в событие action
    4) user_agent пишется отдельным событием
    """
    info = {'timestamp': event['timestamp']}
    for field in ('user_ip', 'yandexuid'):
        if event.get(field):
            info[field] = event[field]
    return info


def serialize_info_from_ordered_dict(ordered_info):
    return [dict(info, value=value) for value, info in iteritems(ordered_info)]


def is_action_account_create_event(event):
    return event['name'] == EVENT_ACTION and event.get('value', '').startswith((
        ACTION_ACCOUNT_CREATE_PREFIX,
        ACTION_ACCOUNT_REGISTER_PREFIX,
    ))


def is_info_ena_event(event):
    return event and event['name'] == EVENT_INFO_ENA


def is_info_ena_disabled_event(event):
    return event and event['name'] == EVENT_INFO_ENA and event.get('value') == '0'


def is_info_ena_enabled_event(event):
    return event and event['name'] == EVENT_INFO_ENA and event.get('value') == '1'


def is_action_delete_event(event):
    return event and event['name'] == EVENT_ACTION and event.get('value') == ACTION_ACCOUNT_DELETE


def is_action_restore_support_link_created_event(event):
    return event and event['name'] == EVENT_ACTION and event['value'] == ACTION_RESTORE_SUPPORT_LINK_CREATED


def is_action_restore_passed_event(event):
    return event['name'] == EVENT_ACTION and event['value'].startswith(ACTION_RESTORE_PASSED_BY_METHOD_PREFIX)


def is_karma_event(event):
    return event['name'] == EVENT_INFO_KARMA


def is_karma_prefix_event(event):
    return event['name'] == EVENT_INFO_KARMA_PREFIX


def is_changing_required_set_event(event):
    return event['name'] == EVENT_SID_LOGIN_RULE and event.get('value') == '8|5'


def is_changing_required_unset_event(event):
    return event['name'] == EVENT_SID_LOGIN_RULE and event.get('value') == '8|1'


def is_action_password_event(event):
    return event['name'] == EVENT_ACTION and event.get('value') == ACTION_ACCOUNT_PASSWORD


def is_action_change_password_event(event):
    return event['name'] == EVENT_ACTION and event.get('value') == ACTION_ACCOUNT_CHANGE_PASSWORD
