# -*- coding: utf-8 -*-

from functools import partial

from passport.backend.core.conf import settings
from passport.backend.core.crypto.key_storage import BaseKeyStorage
from passport.backend.core.crypto.utils import (
    simple_decrypt,
    simple_encrypt,
)


class _HistoryDbKeyStorage(BaseKeyStorage):
    @property
    def _epoch_length(self):
        return settings.HISTORYDB_LOG_ENCRYPTION_KEY_EPOCH_LENGTH

    @property
    def _key_dirpath(self):
        return settings.HISTORYDB_LOG_ENCRYPTION_KEY_DIR


_key_storage = _HistoryDbKeyStorage()

decrypt = partial(simple_decrypt, _key_storage)
encrypt = partial(simple_encrypt, _key_storage)
