# -*- coding: utf-8 -*-

import re


# Имена событий в event-логе
EVENT_INFO_FIRSTNAME = 'info.firstname'
EVENT_INFO_LASTNAME = 'info.lastname'
EVENT_INFO_BIRTHDAY = 'info.birthday'
EVENT_INFO_HINTA = 'info.hinta'
EVENT_INFO_HINTQ = 'info.hintq'
EVENT_INFO_RESTORE_ID = 'info.restore_id'
EVENT_INFO_RESTORE_REQUEST_SOURCE = 'info.restore_request_source'
EVENT_INFO_RESTORE_STATUS = 'info.restore_status'
EVENT_INFO_KARMA = 'info.karma'
EVENT_INFO_KARMA_FULL = 'info.karma_full'
EVENT_INFO_KARMA_PREFIX = 'info.karma_prefix'
EVENT_INFO_ENA = 'info.ena'
EVENT_INFO_DISABLED_STATUS = 'info.disabled_status'
EVENT_INFO_PASSWORD = 'info.password'
EVENT_INFO_SUPPORT_LINK_TYPE = 'info.support_link_type'
EVENT_INFO_FLUSHED_ENTITIES = 'info.flushed_entities'
EVENT_USERINFO_FT = 'userinfo_ft'
EVENT_ACTION = 'action'
EVENT_USER_AGENT = 'user_agent'
EVENT_OLD_YASMS_PHONE_ACTION = 'yasms.phone.action'
EVENT_OLD_YASMS_PHONE_NUMBER = 'yasms.phone.number'
EVENT_OLD_YASMS_PHONE_STATUS = 'yasms.phone.status'
EVENT_EMAIL_PREFIX = 'email.*'
EVENT_EMAIL_GETKEY = 'email.getkey'
EVENT_EMAIL_CONFIRM = 'email.confirm'
EVENT_EMAIL_RPOP = 'email.rpop'
EVENT_EMAIL_DELETE = 'email.delete'
EVENT_SID_LOGIN_RULE = 'sid.login_rule'
EVENT_RESTORE_METHOD_PASSED = 'restore.method_passed'  # событие при прохождении процедуры автоматического восстановления доступа
EVENT_PHONE_PREFIX = 'phone.*'  # события, начинающиеся с префикса phone.
EVENT_APP_KEY_INFO = 'app_key_info'

# Удаление сущностей по саппортской ссылке в перле
ACTION_DELETE_ENTITIES_BY_SUPPORT_LINK_PERL = 'delete_emails_social_profiles'
ACTION_DELETE_ENTITIES_BY_SUPPORT_LINK_WITH_PHONES_PERL = 'delete_emails_phones_social_profiles'
ACTIONS_DELETE_ENTITIES_BY_SUPPORT_LINK_PERL = {
    ACTION_DELETE_ENTITIES_BY_SUPPORT_LINK_PERL,
    ACTION_DELETE_ENTITIES_BY_SUPPORT_LINK_WITH_PHONES_PERL,
}

# значения для события action при регистрации
ACTION_ACCOUNT_CREATE_PREFIX = 'account_create'
ACTION_ACCOUNT_REGISTER_PREFIX = 'account_register'
ACTION_ACCOUNT_DELETE = 'delete'
ACTION_ACCOUNT_PASSWORD = 'password'
ACTION_ACCOUNT_CHANGE_PASSWORD = 'change_password'

# NB: Идущие далее значения также используются при записи информации в statbox
# в качестве идентификаторов

# Запрос на проверку полной анкеты для восстановления пароля
ACTION_RESTORE_SEMI_AUTO_REQUEST = 'restore_semi_auto_request'
# Решение саппорта по результатам обработки анкеты
ACTION_RESTORE_SEMI_AUTO_DECISION = 'restore_semi_auto_decision'
# Запрос на проверку короткой анкеты для восстановления пароля
ACTION_RESTORE_SHORT_FORM_REQUEST = 'restore_short_form_request'

# Саппортом сгенерирована ссылка для восстановления доступа к аккаунту
ACTION_RESTORE_SUPPORT_LINK_CREATED = 'restore_support_link_created'

# Сброс данных на аккаунте при завершении восстановления
ACTION_RESTORE_ENTITIES_FLUSHED = 'restore_entities_flushed'

# Успешно пройдено новое восстановление
ACTION_RESTORE_PASSED_BY_METHOD_PREFIX = 'restore_passed_by'
ACTION_RESTORE_PASSED_BY_METHOD_REGEXP = re.compile(r'^restore_passed_by_(?P<method>\w+)$')

# Отказано в попытке восстановить пароль
RESTORE_STATUS_REJECTED = 'rejected'
# Анкета отправлена на рассмотрение саппорту
RESTORE_STATUS_PENDING = 'pending'
# Короткая анкета заполнена корректно и пользователю разрешается сменить пароль
RESTORE_STATUS_PASSED = 'passed'

# Принудительная смена пароля
PASSWORD_CHANGE_TYPE_FORCED = 'forced'

# Добровольная смена пароля
PASSWORD_CHANGE_TYPE_VOLUNTARY = 'voluntary'

# Смена пароля при восстановлении
PASSWORD_CHANGE_TYPE_RESTORE = 'restore'
