PY23_LIBRARY()

OWNER(
    g:passport_python
)

NEED_REVIEW()

PEERDIR(
    passport/backend/core/undefined
    passport/backend/core/builders/historydb_api
    passport/backend/core/conf
    passport/backend/core/crypto
    passport/backend/core/env
    passport/backend/core/exceptions
    passport/backend/core/portallib
    passport/backend/core/types
    passport/backend/core/types/ip
    passport/backend/core/types/phone_number
    passport/backend/core/types/email
    passport/backend/core/types/question
    passport/backend/core/utils
)

PY_SRCS(
    __init__.py
    account_history/__init__.py
    account_history/account_history.py
    account_history/event_parsers/__init__.py
    account_history/event_parsers/app_password.py
    account_history/event_parsers/base.py
    account_history/event_parsers/email.py
    account_history/event_parsers/glogout.py
    account_history/event_parsers/hint.py
    account_history/event_parsers/parser.py
    account_history/event_parsers/password.py
    account_history/event_parsers/personal_data.py
    account_history/event_parsers/phone.py
    account_history/event_parsers/restore.py
    account_history/event_parsers/totp.py
    analyzer/__init__.py
    analyzer/event_handlers/__init__.py
    analyzer/event_handlers/account_state.py
    analyzer/event_handlers/base.py
    analyzer/event_handlers/email.py
    analyzer/event_handlers/helpers.py
    analyzer/event_handlers/other.py
    analyzer/event_handlers/password.py
    analyzer/event_handlers/phone.py
    analyzer/event_handlers/question_answer.py
    analyzer/event_handlers/restore.py
    analyzer/events.py
    converter.py
    crypto.py
    entry.py
    events.py
    exceptions.py
    statuses.py
)

END()

RECURSE_FOR_TESTS(
    tests
)
