# -*- coding: utf-8 -*-
from passport.backend.core.conf import settings
from passport.backend.core.lazy_loader import (
    lazy_loadable,
    LazyLoader,
)
import yenv


@lazy_loadable(name='Host')
class Host(object):
    def __init__(self):
        self.hosts = {host.name: host for host in settings.HOSTS}
        if yenv.type == 'development':
            default_host = self.hosts.get('localhost')
        else:
            default_host = None
        self.host = self.hosts.get(settings.CURRENT_FQDN, default_host)
        if self.host is None:
            raise RuntimeError('Host %s not found in settings.HOSTS %s' % (settings.CURRENT_FQDN, settings.HOSTS))

    def get_id(self):
        return self.host.id

    def get_dc(self):
        return self.host.dc


def get_current_host():
    return LazyLoader.get_instance('Host')


def is_host_current(hostname):
    return hostname in {'localhost', get_current_host().host.name}
