# -*- coding: utf-8 -*-

from google.protobuf.json_format import MessageToDict
import mock
from nose.tools import (
    eq_,
    ok_,
)
from passport.backend.core.logbroker.logbroker import NamedSingletonMeta


class FakeLogbrokerWriterProto(mock.Mock):
    def __init__(self, cls, name):
        super(FakeLogbrokerWriterProto, self).__init__(name='fake_logbroker_{}'.format(name))
        key = (cls, name)
        self._patch = mock.patch.dict(NamedSingletonMeta._instances, {key: self})
        self.send_calls = mock.Mock()
        self.requests = []

    def start(self):
        self._patch.start()

    def stop(self):
        self._patch.stop()

    @property
    def dict_requests(self):
        return [MessageToDict(request, preserving_proto_field_name=True) for request in self.requests]

    def send(self, payload):
        self.send_calls(payload=payload)
        self.requests.append(payload)

    def set_send_side_effect(self, side_effect):
        self.send_calls.side_effect = side_effect

    def assert_message_sent(self, message, as_dict=True):
        if as_dict:
            requests = self.dict_requests
        else:
            requests = self.requests
        eq_(len(requests), 1)
        eq_(requests[0], message)

    def assert_messages_sent(self, messages, strict=False, as_dict=True):
        if as_dict:
            requests = self.dict_requests
        else:
            requests = self.requests
        if strict:
            expected = messages
            eq_(requests, expected)
        else:
            expected = messages
            assertion_message = 'Sent:\n{}\ndoes not contain\n{}'.format(
                requests, expected,
            )
            ok_(all(e in requests for e in expected), assertion_message)
