# -*- coding: utf-8 -*-

import logging

from passport.backend.core.logging_utils.loggers.tskv import TskvLogEntry
from passport.backend.core.logging_utils.request_id import get_request_id


class RequestIdFilter(logging.Filter):
    def filter(self, record):
        record.request_id = get_request_id()
        return True


class TskvRequestIdFilter(RequestIdFilter):
    def filter(self, record):
        record.request_id = TskvLogEntry.escape_value(get_request_id())
        return True
