# -*- coding: utf-8 -*-
import logging

from passport.backend.core.logging_utils.formatters import ExceptionFormatter
import ylog


class ExceptionHandler(logging.Handler):
    """
    Аналог ylog.ExceptionHandler, использующий OSFileHandler и скрывающий секретные данные.
    """

    def __init__(self, log_path, formatter_class=None):
        super(ExceptionHandler, self).__init__()
        formatter_class = formatter_class or ExceptionFormatter
        exception_file = ylog.handlers.OSFileHandler(filename=log_path + 'exception.log')
        exception_file.setFormatter(formatter_class())
        traceback_file = ylog.handlers.OSFileHandler(filename=log_path + 'traceback.log')
        traceback_file.setFormatter(formatter_class(full=True))
        self.handlers = [
            exception_file,
            traceback_file,
        ]

    def emit(self, record):
        for handler in self.handlers:
            handler.emit(record)
