# -*- coding: utf-8 -*-

from passport.backend.core.logging_utils.loggers.tskv import (
    TskvLogEntry,
    TskvLogger,
)


class AccessLogEntry(TskvLogEntry):
    """
    Access-лог в формате tskv
    """

    def __init__(self, **params):
        params.setdefault('tskv_format', 'passport-api-access-log')
        super(AccessLogEntry, self).__init__(**params)


class AccessLogger(TskvLogger):
    default_logger_name = 'access'
    entry_class = AccessLogEntry
