# -*- coding: utf-8 -*-

from passport.backend.core.logging_utils.loggers.tskv import (
    TskvLogEntry,
    TskvLogger,
)
from passport.backend.utils.time import get_unixtime


class AvatarsLogEntry(TskvLogEntry):
    """
    Лог для отправки аватарок в логброкер для асинхронной загрузки
    """

    def __init__(self, **params):
        params.setdefault('tskv_format', 'avatars-log')
        params.setdefault('unixtime', get_unixtime())
        super(AvatarsLogEntry, self).__init__(**params)


class AvatarsLogger(TskvLogger):
    default_logger_name = 'avatars'
    entry_class = AvatarsLogEntry
