# -*- coding: utf-8 -*-

from passport.backend.core.logging_utils.loggers.tskv import (
    TskvLogEntry,
    TskvLogger,
)
from passport.backend.utils.time import get_unixtime


class FamilyLogEntry(TskvLogEntry):
    """
    Лог семьи в формате tskv
    """

    def __init__(self, **params):
        params.setdefault('tskv_format', 'passport-family-log')
        params.setdefault('unixtime', get_unixtime())
        super(FamilyLogEntry, self).__init__(**params)


class FamilyLogger(TskvLogger):
    default_logger_name = 'passport_family'
    entry_class = FamilyLogEntry
