# -*- coding: utf-8 -*-
"""Ведение журнала для нужд Graphite"""

from passport.backend.core.logging_utils.loggers.tskv import (
    TskvLogEntry,
    TskvLogger,
)
from passport.backend.utils.time import (
    get_unixtime,
    unixtime_to_datetime,
)


TIMEOUT_RESPONSE_CODE = 'timeout'
SUCCESS_RESPONSE_CODE = 'success'
FAILED_RESPONSE_CODE = 'failed'


class GraphiteLogEntry(TskvLogEntry):

    DATETIME_FORMAT = '%d/%b/%Y:%H:%M:%S'

    def __init__(self, **params):
        params.setdefault('tskv_format', 'passport-log')
        params.setdefault('unixtime', get_unixtime())
        # Для удобства чтения в каждую строку помещаем легко читаемую временную
        # метку
        if 'timestamp' not in params:
            params['timestamp'] = unixtime_to_datetime(params['unixtime']).strftime(self.DATETIME_FORMAT)
        super(GraphiteLogEntry, self).__init__(**params)


class GraphiteLogger(TskvLogger):
    """Ведёт журнал для нужд Graphite"""

    default_logger_name = 'passport.graphite_logger'
    entry_class = GraphiteLogEntry
