# -*- coding: utf-8 -*-
"""
Запись телефонов пользователей при авторизации.
https://st.yandex-team.ru/PASSP-9050
"""

from passport.backend.core.logging_utils.loggers.tskv import (
    TskvLogEntry,
    TskvLogger,
)
from passport.backend.utils.time import get_unixtime


class PhoneLogEntry(TskvLogEntry):
    def __init__(self, **params):
        params.setdefault('tskv_format', 'passport-phone-log')
        params.setdefault('unixtime', get_unixtime())
        super(PhoneLogEntry, self).__init__(**params)


class PhoneLogger(TskvLogger):
    """Запись телефонов пользователей при авторизации."""

    default_logger_name = 'passport.phone_logger'
    entry_class = PhoneLogEntry
