# -*- coding: utf-8 -*-

from passport.backend.core.logging_utils.loggers.tskv import (
    TskvLogEntry,
    TskvLogger,
)
from passport.backend.utils.time import get_unixtime


class PushLogEntry(TskvLogEntry):
    """
    Лог пушей в формате tskv
    """

    def __init__(self, **params):
        params.setdefault('tskv_format', 'passport-push-log')
        params.setdefault('unixtime', get_unixtime())
        super(PushLogEntry, self).__init__(**params)


class PushLogger(TskvLogger):
    default_logger_name = 'passport_push'
    entry_class = PushLogEntry
